/****** Object:  UserDefinedFunction [dbo].[F_DIA_PREV_FECHA_VENC_CRED]    Script Date: 04/29/2014 23:12:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[F_DIA_PREV_FECHA_VENC_CRED]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[F_DIA_PREV_FECHA_VENC_CRED]
GO 
/****** Object:  UserDefinedFunction [dbo].[F_DIA_PREV_FECHA_VENC_CRED]    Script Date: 21/05/2015 17:00:49 ******/
SET ANSI_NULLS ON
GO 
SET QUOTED_IDENTIFIER ON
GO

--SELECT DBO.F_DIA_PREV_FECHA_VENC_CRED(1,62300,'2011-01-27',1,0)
CREATE FUNCTION [dbo].[F_DIA_PREV_FECHA_VENC_CRED]( @CD_EMP INT, @CD_CLI  INT, @DT_VENDA	DATETIME, @NR_PARC	INT,  @TP_PREV	INT)  

RETURNS DATETIME
WITH ENCRYPTION 

AS
BEGIN

DECLARE @CD_MDL_VD  INT
DECLARE @POSICAO	INT
DECLARE @DAY_ADD    INT

SET @POSICAO	= 1

SET @CD_MDL_VD	= (SELECT CD_MDL_VD 
				   FROM RC_CLI_CREDIARIO 
				   WHERE CD_EMP = @CD_EMP 
						AND CD_CLI = @CD_CLI)

IF @CD_MDL_VD is null
	BEGIN
		SET @DT_VENDA = CONVERT(VARCHAR(10), GETDATE(), 101)
		RETURN @DT_VENDA
	END
	
						
WHILE @POSICAO <= @NR_PARC
	BEGIN
	
	
SELECT  @DT_VENDA = dbo.F_RET_DATA_VALIDA(
		(CASE WHEN RC_MDL_VENDA.TP_FECHA = 0 THEN --Dia do Ms
			CASE WHEN DAY(@DT_VENDA) > RC_MDL_VENDA.DIA_FECHA THEN
				CAST(YEAR(DATEADD(MONTH, 1, @DT_VENDA)) AS VARCHAR) + RIGHT('0' + CAST(MONTH(DATEADD(MONTH, 1, @DT_VENDA)) AS VARCHAR),2) + RIGHT('0' +CAST(RC_MDL_VENDA.DIA_FECHA AS VARCHAR),2)		
			ELSE
				CAST(YEAR(@DT_VENDA) AS VARCHAR) + RIGHT('0' + CAST(MONTH(@DT_VENDA) AS VARCHAR),2) + RIGHT('0' +CAST(RC_MDL_VENDA.DIA_FECHA AS VARCHAR),2)			
			END

		WHEN RC_MDL_VENDA.TP_FECHA = 1 THEN --Dias aps venda	
																																								
			CONVERT(CHAR(10), DATEADD(DAY, RC_MDL_VENDA.DIA_FECHA, @DT_VENDA), 112)		
																									
		WHEN RC_MDL_VENDA.TP_FECHA = 2 THEN --Dia da semana
			(CASE WHEN DATEPART(DW, @DT_VENDA) >= RC_MDL_VENDA.DIA_FECHA THEN
				CONVERT(CHAR(10), DATEADD(DAY, (7 - DATEPART(DW, @DT_VENDA)) + RC_MDL_VENDA.DIA_FECHA, @DT_VENDA), 112)								 
			ELSE
				CONVERT(CHAR(10), DATEADD(DAY, RC_MDL_VENDA.DIA_FECHA - DATEPART(DW, @DT_VENDA) , @DT_VENDA), 112)
			END)

		WHEN RC_MDL_VENDA.TP_FECHA = 3 THEN --Quinzenal
			(CASE WHEN DAY(@DT_VENDA) <= 15 THEN
				CONVERT(CHAR(10), DBO.F_FINAL_MES(@DT_VENDA), 112)
			ELSE
				CONVERT(CHAR(10), DATEADD(DAY, 15, DBO.F_FINAL_MES(@DT_VENDA)), 112)									
			END)
	
	---------------------- falta o tp_fecha = 4 ------------------
		WHEN RC_MDL_VENDA.TP_FECHA = 4 THEN -- Fechamento imediato por venda
			CONVERT(CHAR(10), @DT_VENDA, 112)			
	--------------------------------------------------------------

		END)),
		@DAY_ADD = CASE WHEN RC_MDL_VENDA.TP_FECHA = 1 THEN  DIA_VENCTO ELSE 1 END
	FROM RC_MDL_VENDA
	WHERE CD_MDL_VD = @CD_MDL_VD

		IF @POSICAO <> @NR_PARC 
			BEGIN 
					
				--SET @DT_VENDA = DATEADD(DAY, @DAY_ADD, @DT_VENDA)
				SET @DT_VENDA = DATEADD(MONTH, 1, @DT_VENDA) 
				
			END

		SET @POSICAO = @POSICAO + 1
	END


IF @TP_PREV = 1 
	BEGIN
	
		SET @DT_VENDA = (SELECT DBO.F_RET_DATA_VALIDA  ((CASE WHEN TP_VENCTO = 0 THEN --Dia do Ms
																 CASE WHEN DAY(@DT_VENDA) > DIA_VENCTO THEN
																	CAST(YEAR(DATEADD(MONTH, 1, @DT_VENDA)) AS VARCHAR) + RIGHT('0' + CAST(MONTH(DATEADD(MONTH, 1, @DT_VENDA)) AS VARCHAR),2) + RIGHT('0' +CAST(DIA_VENCTO AS VARCHAR),2)		
																 ELSE
																	CAST(YEAR(@DT_VENDA) AS VARCHAR) + RIGHT('0' + CAST(MONTH(@DT_VENDA) AS VARCHAR),2) + RIGHT('0' +CAST(DIA_VENCTO AS VARCHAR),2)			
																 END

														 WHEN TP_VENCTO = 1 THEN --Dias aps fechamento
																(CASE WHEN NOT @DT_VENDA IS NULL THEN
																	CONVERT(CHAR(10), DATEADD(DAY, DIA_VENCTO, @DT_VENDA), 112)
																 ELSE
																	NULL
																 END)

														 WHEN TP_VENCTO = 2 THEN --Dia da semana
																(CASE WHEN DATEPART(DW, @DT_VENDA) >= DIA_VENCTO THEN
																	CONVERT(CHAR(10), DATEADD(DAY, (7 - DATEPART(DW, @DT_VENDA)) + DIA_VENCTO, @DT_VENDA), 112)								 
																 ELSE
																	CONVERT(CHAR(10), DATEADD(DAY, DIA_VENCTO - DATEPART(DW, @DT_VENDA) , @DT_VENDA), 112)
																 END)

														 WHEN TP_VENCTO = 3 THEN --Quinzenal
																(CASE WHEN DAY(@DT_VENDA) <= 15 THEN
																	CONVERT(CHAR(10), DBO.F_FINAL_MES(@DT_VENDA), 112)
																 ELSE
																	CONVERT(CHAR(10), DATEADD(DAY, 15, DBO.F_FINAL_MES(@DT_VENDA)), 112)									
																 END)
														 END))
						 FROM RC_MDL_VENDA
						 WHERE CD_MDL_VD = @CD_MDL_VD)	
	END

RETURN @DT_VENDA

END 

GO

